<?php

// --- 1. CONFIGURAÇÕES FIXAS (Autoridades e Localização) ---
const DIRECTOR_NOME = 'JORGE JOAQUIM MANECO';
const MUNICIPAL_EDUCACAO = 'DIREÇÃO MUNICIPAL DA EDUCAÇÃO DE BENGUELA';
const LOCAL_DATA_FIXA = 'DIRECÇÃO MUNICIPAL DA EDUCAÇÃO DE BENGUELA, AOS ';
const DATA_ATUAL = '07 DE OUTUBRO DE 2025'; 

// =========================================================================
// !!! BLOCO DE INTEGRAÇÃO DA BASE DE DADOS !!!
// =========================================================================

// PASSO 1: Incluir o arquivo de conexão
try {
    include 'conexao.php';
    if (!isset($conn) || !$conn instanceof mysqli) {
        throw new Exception("A variável \$conn não foi definida ou não é uma conexão válida em conexao.php.");
    }
} catch (Exception $e) {
    die("Erro fatal: " . $e->getMessage());
}

$funcionarios_listagem = [];
$funcionario_selecionado_detalhes = [];
$conn_status_message = '';

// --- Consulta 1: Listagem de Funcionários (Para a barra lateral) ---
$sql_listagem = "SELECT id, nome, agente FROM usuarios ORDER BY nome ASC";

$result_listagem = $conn->query($sql_listagem);
if ($result_listagem) {
    $funcionarios_listagem = $result_listagem->fetch_all(MYSQLI_ASSOC);
    $conn_status_message = 'Conexão e listagem de usuários OK.';
} else {
    $conn_status_message = "ERRO NA CONSULTA 1 (Listagem): " . $conn->error;
    $funcionarios_listagem = [['id' => 0, 'nome' => $conn_status_message, 'agente' => 'Erro']];
}


// --- Lógica de Seleção ---
$user_id = (int)($_GET['user'] ?? 0);
$template_id = $_GET['doc'] ?? null;
$funcionario_selecionado = null; 

foreach ($funcionarios_listagem as $func) {
    if ($func['id'] == $user_id) { 
        $funcionario_selecionado = $func;
        break;
    }
}

// --- Consulta 2: Detalhes Completos do Funcionário Selecionado ---
if ($funcionario_selecionado && $user_id > 0 && isset($conn)) {
    
    $sql_detalhes = "
        SELECT 
            nome, agente, bi, data_bi, categoria, salario_liq, 
            salario_extenso, escola, iban, ano_inicio, ano_fim, 
            total_anos, data_inicio_completa
        FROM usuarios
        WHERE id = ?
    ";
    
    $stmt = $conn->prepare($sql_detalhes);
    if ($stmt) {
        $stmt->bind_param('i', $user_id);
        $stmt->execute();
        $result_detalhes = $stmt->get_result();
        
        if ($result_detalhes && $result_detalhes->num_rows > 0) {
            $funcionario_selecionado_detalhes = $result_detalhes->fetch_assoc();
            $funcionario_selecionado = array_merge($funcionario_selecionado, $funcionario_selecionado_detalhes);
        } else {
             $conn_status_message .= " | ERRO: Detalhes não encontrados para o ID {$user_id}.";
        }
        $stmt->close();
    } else {
        $conn_status_message .= " | ERRO AO PREPARAR CONSULTA 2: " . $conn->error;
    }
    
    if (!isset($funcionario_selecionado['categoria'])) {
         $funcionario_selecionado['categoria'] = 'Detalhes do Cargo não encontrados no BD';
    }
}

// =========================================================================
// !!! FIM DO BLOCO DE INTEGRAÇÃO !!!
// =========================================================================


// --- 3. DEFINIÇÃO DOS MODELOS DE DOCUMENTOS (Templates) ---
$documentos = [
    'residencia' => [
        'nome' => 'Declaração de Aquisição de Residência',
        'finalidade' => 'aquisição de uma residência junto ao Fundo de Fomento Habitacional',
        'template' => '
            <p class="text-center font-bold">DECLARAÇÃO DE EFECTIVIDADE</p>
            <p>{{DIRECTOR}} , Director Municipal de Educação, declara para efeitos de {{FINALIDADE}}, que o(a) Senhor(a) **{{NOME}}**, é funcionário(a) do Ministério da Educação, colocado(a) no(a) {{ESCOLA}}, portador(a) do B.I nº **{{BI}}**, passado pelo Arquivo de Identificação de Benguela aos **{{DATA_BI}}**, com a categoria de **{{CATEGORIA}}**, agente nº **{{AGENTE}}**, auferindo um salário líquido mensal de AOA **{{SALARIO_LIQ}}** {{SALARIO_EXTENSO}}.</p>
            <p>Por ser verdade e me ter sido solicitada, mandei passar a presente Declaração, que vai por mim assinada e autenticada com o Carimbo a óleo em uso nesta Direcção Municipal de Educação.</p>
        ',
    ],
    'tempo_servico' => [
        'nome' => 'Declaração de Contagem de Tempo de Serviço',
        'finalidade' => 'contagem de tempo de serviço',
        'template' => '
            <p class="text-center font-bold">DECLARAÇÃO DE EFECTIVIDADE</p>
            <p>{{DIRECTOR}} , Director Municipal de Educação, declara para efeitos de {{FINALIDADE}}, que o(a) Senhor(a) **{{NOME}}**, foi funcionário(a) do Ministério da Educação em efectivo serviço, controlado(a) por esta Direcção Municipal de Educação, no período de **{{ANO_INICIO_EXT}}** à **{{ANO_FIM_EXT}}**, totalizando **{{TOTAL_ANOS}}** anos de serviço.</p>
            <p>Por ser verdade e me ter sido solicitada, mandei passar a presente Declaração, que vai por mim assinada e autenticada com o Carimbo a óleo em uso nesta Direcção Municipal de Educação.</p>
        ',
    ],
    'mudanca_banco' => [
        'nome' => 'Declaração de Mudança de Banco',
        'finalidade' => 'mudança de Banco para domiciliação dos salários',
        'template' => '
            <p class="text-center font-bold">DECLARAÇÃO DE EFECTIVIDADE</p>
            <p>{{DIRECTOR}} , Director Municipal de Educação, declara para efeitos de {{FINALIDADE}}, que o(a) Senhor(a) **{{NOME}}**, com a categoria de **{{CATEGORIA}}**, agente nº **{{AGENTE}}**, funcionário(a) colocado(a) no(a) **{{ESCOLA}}** com a conta bancária com IBAN n.º **{{IBAN}}**.</p>
            <p>Por ser verdade e me ter sido solicitada, mandei passar a presente Declaração, que vai por mim assinada e autenticada com o Carimbo a óleo em uso nesta Direcção Municipal de Educação.</p>
        ',
    ],
    'subsidio_morte' => [
        'nome' => 'Declaração de Subsídio de Morte (Pensão)',
        'finalidade' => 'obtenção de pensão alimentar dos menores sobrevivos de {{NOME}}',
        'template' => '
            <p class="text-center font-bold">DECLARAÇÃO DE EFECTIVIDADE</p>
            <p>{{DIRECTOR}} , Director Municipal de Educação, declara para efeitos de {{FINALIDADE}}, que este foi funcionário do Sector da Educação, colocado no {{ESCOLA}} com a categoria de **{{CATEGORIA}}**, tendo iniciado suas funções aos **{{DATA_INICIO_COMPLETA}}**, atividade que exerceu até o ano de **{{ANO_FIM}}**, totalizando **{{TOTAL_ANOS}}** anos de efetivo serviço.</p>
            <p>Por ser verdade e me ter sido solicitada, mandei passar a presente Declaração, que vai por mim assinada e autenticada com o Carimbo a óleo em uso nesta Direcção Municipal de Educação.</p>
        ',
    ],
];

// --- 4. LÓGICA DE GERAÇÃO DINÂMICA DO DOCUMENTO ---

$documento_final = null;
$nome_documento = 'Selecione um funcionário e um documento';

if ($funcionario_selecionado && $template_id && isset($documentos[$template_id])) {
    $doc_info = $documentos[$template_id];
    $nome_documento = $doc_info['nome'];
    $template = $doc_info['template'];

    // Mapeamento dos dados do funcionário
    $placeholders = [
        '{{DIRECTOR}}' => DIRECTOR_NOME,
        '{{FINALIDADE}}' => $doc_info['finalidade'],
        '{{NOME}}' => $funcionario_selecionado['nome'] ?? 'NÃO ENCONTRADO',
        '{{BI}}' => $funcionario_selecionado['bi'] ?? 'NÃO ENCONTRADO',
        '{{DATA_BI}}' => $funcionario_selecionado['data_bi'] ?? 'NÃO ENCONTRADO',
        '{{CATEGORIA}}' => $funcionario_selecionado['categoria'] ?? 'NÃO ENCONTRADO',
        '{{AGENTE}}' => $funcionario_selecionado['agente'] ?? 'NÃO ENCONTRADO',
        '{{SALARIO_LIQ}}' => $funcionario_selecionado['salario_liq'] ?? 'NÃO ENCONTRADO',
        '{{SALARIO_EXTENSO}}' => $funcionario_selecionado['salario_extenso'] ?? '(Valor por extenso não disponível)',
        '{{ESCOLA}}' => $funcionario_selecionado['escola'] ?? 'NÃO ENCONTRADO',
        '{{IBAN}}' => $funcionario_selecionado['iban'] ?? 'NÃO ENCONTRADO',
        '{{ANO_INICIO_EXT}}' => 'Mil Novecentos e ' . ($funcionario_selecionado['ano_inicio'] ?? 'XX'),
        '{{ANO_FIM_EXT}}' => 'Mil Novecentos e ' . ($funcionario_selecionado['ano_fim'] ?? 'XX'),
        '{{TOTAL_ANOS}}' => $funcionario_selecionado['total_anos'] ?? 'XX',
        '{{DATA_INICIO_COMPLETA}}' => $funcionario_selecionado['data_inicio_completa'] ?? 'NÃO ENCONTRADO',
    ];

    $documento_final = str_replace(array_keys($placeholders), array_values($placeholders), $template);

    if ($template_id === 'subsidio_morte') {
        $documento_final = str_replace(
            $doc_info['finalidade'], 
            str_replace('{{NOME}}', $funcionario_selecionado['nome'] ?? 'NÃO ENCONTRADO', $doc_info['finalidade']),
            $documento_final
        );
    }
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerador de Documentos RH - Dinâmico</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>
    <style>
        /* Estilos CSS para formato oficial (APENAS TELA) */
        .declaration-content p { 
            margin-bottom: 0.5rem; /* Espaçamento entre parágrafos (oficial) */
            line-height: 1.5;     
            text-align: justify; 
            text-indent: 1.5cm; /* Recuo na primeira linha */
        }

        .declaration-content .text-center {
            text-indent: 0;
            margin-bottom: 2rem !important; /* Espaçamento após o título */
        }

        /* Classes para controlar o espaçamento do rodapé na tela */
        .footer-date {
            margin-top: 1.5rem; /* Espaçamento da data */
            text-align: right;
        }

        .footer-signature {
            margin-top: 40px; /* Espaçamento da assinatura */
            text-align: center;
        }
        
        .signature-line {
            margin-top: 50px; 
            margin-bottom: 2px;
        }

        .print-area .text-right p,
        .print-area .text-center p {
            text-indent: 0;
        }
        
        /* Regra básica para esconder a barra lateral se o usuário usar o CTRL+P (o @page detalhado foi movido para imprimir_documento.php) */
        @media print {
            .no-print { display: none !important; }
            .print-area { box-shadow: none; border: none !important; padding: 0 !important; margin: 0; width: 100%; }
            body { 
                padding: 0 !important; 
                margin: 0 !important; 
                font-family: 'Times New Roman', Times, serif; 
                font-size: 12pt; 
            }
        }
    </style>
</head>
<body class="bg-gray-50 font-sans">

    <div class="flex h-screen">
        
        <div class="no-print w-96 bg-gray-800 text-white p-6 shadow-2xl flex-shrink-0 overflow-y-auto">
            <h2 class="text-2xl font-bold mb-6 border-b border-gray-700 pb-3">Funcionários (Tabela USUARIOS)</h2>
            
            <?php if (strpos($conn_status_message, 'ERRO') !== false): ?>
                <p class="text-red-400 p-2 bg-red-900 rounded-md text-sm"><?= $conn_status_message ?></p>
            <?php endif; ?>
            
            <ul class="space-y-4">
                <?php if (empty($funcionarios_listagem)): ?>
                    <p class="text-gray-400">Nenhum funcionário encontrado.</p>
                <?php endif; ?>

                <?php foreach ($funcionarios_listagem as $func): ?>
                    <li class="bg-gray-700 rounded-lg p-3 shadow-md">
                        <a href="?user=<?= $func['id'] ?>" 
                            class="block text-lg font-semibold hover:text-blue-400 transition <?= $user_id == $func['id'] ? 'text-blue-400' : 'text-white' ?>">
                            <i class="fas fa-user-circle mr-2"></i> <?= htmlspecialchars($func['nome']) ?>
                        </a>
                        <p class="text-sm text-gray-400 ml-5">Agente N.º: <?= htmlspecialchars($func['agente'] ?? 'N/A') ?></p>

                        <?php if ($user_id == $func['id']): ?>
                            <div class="mt-3 ml-4 border-t border-gray-600 pt-3 space-y-2">
                                <h4 class="font-bold text-gray-300">Documentos:</h4>
                                <?php foreach ($documentos as $doc_id => $doc): ?>
                                    <a href="?user=<?= $func['id'] ?>&doc=<?= $doc_id ?>" 
                                        class="block text-sm p-2 rounded hover:bg-gray-600 transition <?= $template_id === $doc_id ? 'bg-blue-600 font-semibold' : 'bg-gray-700' ?>">
                                        <i class="fas fa-file-alt mr-2"></i> <?= htmlspecialchars($doc['nome']) ?>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>

        <div class="flex-1 overflow-y-auto p-8">
            <h1 class="text-3xl font-bold text-gray-800 mb-4 no-print">Gerador de Documentos RH</h1>
            
            <p class="text-gray-500 mb-8 no-print">
                <?php 
                echo $funcionario_selecionado ? "Funcionário Selecionado: <strong>{$funcionario_selecionado['nome']}</strong>" : 'Selecione um funcionário na lista à esquerda.';
                ?>
            </p>
            
            <?php if ($documento_final): ?>
                
                <div class="flex justify-between items-center mb-6 no-print">
                    <h2 class="text-2xl font-semibold text-blue-900 border-b pb-2"><?= htmlspecialchars($nome_documento) ?></h2>
                    
                    <button onclick="window.open('imprimir_documento.php?user=<?= $user_id ?>&doc=<?= $template_id ?>', '_blank')" 
                            class="bg-green-600 text-white px-6 py-2 rounded-lg hover:bg-green-700 transition">
                        <i class="fas fa-print"></i> Imprimir Documento
                    </button>
                </div>

                <div class="print-area bg-white p-12 lg:p-16 rounded-xl shadow-2xl border border-gray-300 w-full max-w-4xl mx-auto">
                    
                    <div class="text-center mb-8">
                        <div class="flex justify-center mb-4">
                            <img src="insignia/insignia.png" alt="Insígnia" class="w-16 h-auto"> 
                        </div>
                        <p class="text-sm">REPÚBLICA DE ANGOLA</p>
                        <p class="text-sm">GOVERNO PROVINCIAL DE BENGUELA</p>
                        <p class="text-sm font-semibold mb-4"><?= MUNICIPAL_EDUCACAO ?></p>
                        <hr class="w-1/3 mx-auto mb-6 border-t-2 border-gray-400">
                    </div>

                    <div id="declaration-preview" class="declaration-content min-h-[500px]">
                        <?= $documento_final ?>
                    </div>

                    <div class='footer-date'> 
                        <p class="text-sm"><?= LOCAL_DATA_FIXA . DATA_ATUAL ?></p>
                    </div>
                    
                    <div class='footer-signature'>
                        <p class="text-sm">O DIRECTOR MUNICIPAL</p>
                        <div class="signature-line w-2/3 mx-auto border-t border-black"></div> 
                        <p class='font-bold mt-2'><?= DIRECTOR_NOME ?></p>
                    </div>
                </div>
                
            <?php else: ?>
                <div class="text-center p-20 bg-white rounded-xl shadow-lg">
                    <h2 class="text-2xl text-gray-600">Selecione um funcionário e, em seguida, um documento para gerar.</h2>
                    <p class="text-gray-400 mt-4">Execute o SQL e preencha as novas colunas na sua tabela `usuarios` para que os dados sejam exibidos aqui.</p>
                </div>
            <?php endif; ?>

        </div>
    </div>

</body>
</html>